/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.recipes.HPRecipeBase;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;

public class TileEntityHandGrindstone
extends TileEntityHPBase
implements ITickable {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{1, 2};
    private int currentItemMillTime;
    private int totalItemMillTime;
    private final int ticksPerRotation = 18;
    private float visibleRotation = 0.0f;
    private int currentTicks = 0;
    private int rotation = 0;

    public TileEntityHandGrindstone() {
        super(3);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("millTime", this.currentItemMillTime);
        compound.func_74768_a("totalMillTime", this.totalItemMillTime);
        compound.func_74768_a("currentRotation", this.rotation);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (this.func_70301_a(0).func_190916_E() > 0) {
            this.currentItemMillTime = compound.func_74762_e("millTime");
            this.totalItemMillTime = compound.func_74762_e("totalMillTime");
            this.rotation = compound.func_74762_e("currentRotation");
        } else {
            this.currentItemMillTime = 0;
            this.totalItemMillTime = 1;
            this.rotation = 0;
        }
    }

    @Override
    public ItemStack getRecipeItemStack() {
        return HPRecipes.instance().getGrindstoneResult(this.func_70301_a(0));
    }

    @Override
    public HPRecipeBase getRecipe() {
        return HPRecipes.instance().getGrindstoneRecipe(this.func_70301_a(0));
    }

    private void millItem() {
        if (!this.field_145850_b.field_72995_K && this.canWork()) {
            HPRecipeBase recipe = this.getRecipe();
            ItemStack result = recipe.getOutput();
            ItemStack secondary = recipe.getSecondary();
            ItemStack input = this.func_70301_a(0);
            ItemStack output = this.func_70301_a(1);
            ItemStack secondaryOutput = this.func_70301_a(2);
            if (output.func_190926_b()) {
                this.func_70299_a(1, result.func_77946_l());
            } else if (output.func_77969_a(result)) {
                output.func_190917_f(result.func_190916_E());
            }
            TileEntityHandGrindstone.processSecondaries(this.func_145831_w(), secondary, secondaryOutput, recipe, this);
            input.func_190918_g(1);
        }
    }

    public static void processSecondaries(World world, ItemStack secondary, ItemStack secondaryOutput, HPRecipeBase recipe, TileEntityHPBase teBase) {
        int recipeChance;
        if (!(secondary.func_190926_b() || (recipeChance = recipe.getSecondaryChance()) < 100 && world.field_73012_v.nextInt(100) >= recipeChance)) {
            if (secondaryOutput.func_190926_b()) {
                teBase.func_70299_a(2, secondary.func_77946_l());
            } else if (secondaryOutput.func_77969_a(secondary)) {
                secondaryOutput.func_190917_f(secondary.func_190916_E());
            }
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : new int[]{});
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (this.func_70301_a(0).func_190926_b()) {
            this.currentItemMillTime = 0;
        }
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        boolean flag;
        ItemStack itemstack = this.func_70301_a(index);
        super.func_70299_a(index, stack);
        boolean bl = flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        if (index == 0 && !flag) {
            this.totalItemMillTime = HPRecipes.instance().getGrindstoneTime(stack);
            this.currentItemMillTime = 0;
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && HPRecipes.instance().hasGrindstoneRecipe(stack);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.totalItemMillTime;
            }
            case 1: {
                return this.currentItemMillTime;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.totalItemMillTime = value;
                break;
            }
            case 1: {
                this.currentItemMillTime = value;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 2;
    }

    public String func_70005_c_() {
        return "container.hand_mill";
    }

    public void turn() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.rotation < 3 && this.canWork()) {
            this.rotation += 18;
            this.func_70296_d();
        }
    }

    public void func_73660_a() {
        if (this.rotation > 0) {
            this.visibleRotation = (this.visibleRotation - 20.0f) % -360.0f;
            ++this.currentTicks;
            if (this.currentTicks >= 18) {
                this.currentTicks -= 18;
                this.currentItemMillTime += Configs.pointsPerRotation;
                if (this.currentItemMillTime >= this.totalItemMillTime) {
                    this.currentItemMillTime = 0;
                    this.millItem();
                    this.totalItemMillTime = HPRecipes.instance().getGrindstoneTime(this.func_70301_a(0));
                }
                this.func_70296_d();
            }
            --this.rotation;
        } else {
            this.visibleRotation = 0.0f;
        }
    }

    public float getVisibleRotation() {
        return this.visibleRotation;
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }
}

