package se.gory_moon.horsepower.tileentity;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.recipes.HPRecipes;

public class TileEntityHandGrindstone extends TileEntityHPBase implements ITickable {

    private static final int[] SLOTS_TOP = new int[] {0};
    private static final int[] SLOTS_BOTTOM = new int[] {1};

    private int currentItemMillTime;
    private int totalItemMillTime;


    private final int ticksPerRotation = 18;
    private float visibleRotation = 0;
    private int currentTicks = 0;
    private int rotation = 0;


    public TileEntityHandGrindstone() {
        super(2);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("millTime", currentItemMillTime);
        compound.func_74768_a("totalMillTime", totalItemMillTime);
        compound.func_74768_a("currentRotation", rotation);

        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);

        if (func_70301_a(0).func_190916_E() > 0) {
            currentItemMillTime = compound.func_74762_e("millTime");
            totalItemMillTime = compound.func_74762_e("totalMillTime");
            rotation = compound.func_74762_e("currentRotation");
        } else {
            currentItemMillTime = 0;
            totalItemMillTime = 1;
            rotation = 0;
        }
    }

    @Override
    public ItemStack getRecipeItemStack() {
        return HPRecipes.instance().getGrindstoneResult(func_70301_a(0));
    }

    private void millItem() {
        if (canWork()) {
            ItemStack input = func_70301_a(0);
            ItemStack result = getRecipeItemStack();
            ItemStack output = func_70301_a(1);

            if (output.func_190926_b()) {
                func_70299_a(1, result.func_77946_l());
            } else if (output.func_77973_b() == result.func_77973_b()) {
                output.func_190917_f(result.func_190916_E());
            }

            input.func_190918_g(1);
        }
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : new int[0]);
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (func_70301_a(0).func_190926_b())
            currentItemMillTime = 0;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = func_70301_a(index);
        super.func_70299_a(index, stack);

        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a(stack, itemstack);
        if (index == 0 && !flag) {
            totalItemMillTime = HPRecipes.instance().getGrindstoneTime(stack);
            currentItemMillTime = 0;
        }
        func_70296_d();
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 1 && index == 0 && HPRecipes.instance().hasGrindstoneRecipe(stack);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0:
                return totalItemMillTime;
            case 1:
                return currentItemMillTime;
            default:
                return 0;
        }
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0:
                totalItemMillTime = value;
                break;
            case 1:
                currentItemMillTime = value;
        }
    }

    @Override
    public int func_174890_g() {
        return 2;
    }

    @Override
    public String func_70005_c_() {
        return "container.hand_mill";
    }

    public void turn() {
        if (func_145831_w().field_72995_K)
            return;

        if (rotation < 3 && canWork()) {
            rotation += ticksPerRotation;
            func_70296_d();
        }
    }

    @Override
    public void func_73660_a() {
        if (rotation > 0) {

            visibleRotation = (visibleRotation - 360 / (ticksPerRotation)) % -360;
            currentTicks++;
            if (currentTicks >= ticksPerRotation) {
                currentTicks -= ticksPerRotation;

                currentItemMillTime += Configs.pointsPerRotation;

                if (currentItemMillTime >= totalItemMillTime) {
                    currentItemMillTime = 0;

                    millItem();
                    totalItemMillTime = HPRecipes.instance().getGrindstoneTime(func_70301_a(0));
                }
                func_70296_d();
            }

            rotation--;
        } else {
            visibleRotation = 0;
        }
    }

    public float getVisibleRotation() {
        return visibleRotation;
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }
}
