package se.gory_moon.horsepower.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.*;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.gory_moon.horsepower.tileentity.TileEntityFiller;

import javax.annotation.Nullable;
import java.util.List;
import java.util.Random;

public class BlockFiller extends BlockDirectional {

    public static final IUnlistedProperty<Integer> MISC_DATA = Properties.toUnlisted(PropertyInteger.func_177719_a("misc_data", 0, 32));
    public boolean useTileEntity;

    public BlockFiller(Material materialIn, String name, boolean useTileEntity) {
        super(materialIn);
        setRegistryName(name + "filler");
        this.useTileEntity = useTileEntity;
    }

    @Nullable
    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityFiller();
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return useTileEntity;
    }

    private IBlockState getFillerState(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos);
    }

    private int getValue(IExtendedBlockState state, int location, int size) {
        return (state.getValue(MISC_DATA) >> location) & ((1 << size) - 1);
    }

    private int setValue(int meta, int location, int value) {
        return meta | (value << location);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState(this, new IProperty[]{ field_176387_N }, new IUnlistedProperty[]{ MISC_DATA });
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return func_176223_P().func_177226_a(field_176387_N, EnumFacing.func_82600_a(meta));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(field_176387_N).func_176745_a();
    }

    @Override
    public IBlockState func_176221_a(IBlockState baseState, IBlockAccess worldIn, BlockPos pos) {
        if (baseState instanceof IExtendedBlockState) {
            IExtendedBlockState extState = (IExtendedBlockState) baseState;
            pos = pos.func_177972_a(extState.func_177229_b(field_176387_N));
            IBlockState state1 = worldIn.func_180495_p(pos);
            int meta = setValue(state1.func_177230_c().func_149744_f(state1)? 1: 0, 0, 1);


            return ((IExtendedBlockState) baseState).withProperty(MISC_DATA, meta);
        }
        return super.func_176221_a(baseState, worldIn, pos);
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Override
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    @Override
    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        IBlockState state = world.func_180495_p(pos);
        if (!((World) world).field_72995_K && pos.func_177972_a(state.func_177229_b(field_176387_N)).equals(neighbor) && world.func_175623_d(neighbor)) {
            ((World) world).func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    @Override
    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        pos = pos.func_177972_a(state.func_177229_b(field_176387_N));
        worldIn.func_175655_b(pos, true);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        pos = pos.func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        return state1.func_177230_c().func_185496_a(state1, world, pos);
    }

    @Override
    public boolean func_180639_a(World w, BlockPos p, IBlockState s, EntityPlayer e, EnumHand h, EnumFacing f, float x, float y, float z) {
        p = p.func_177972_a(s.func_177229_b(field_176387_N));
        IBlockState state1 = w.func_180495_p(p);
        return state1.func_177230_c().func_180639_a(w, p, state1, e, h ,f, x, y, z);
    }

    @Override
    @SideOnly(Side.CLIENT)
    public final AxisAlignedBB func_180640_a(IBlockState s, World w, BlockPos p) {
        p = p.func_177972_a(s.func_177229_b(field_176387_N));
        IBlockState state1 = w.func_180495_p(p);
        return state1.func_177230_c().func_180640_a(state1, w, p);
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        pos = pos.func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = worldIn.func_180495_p(pos);
        state1.func_177230_c().func_185477_a(state1, worldIn, pos, entityBox, collidingBoxes, entityIn, p_185477_7_);
    }

    @Override
    public final RayTraceResult func_180636_a(IBlockState s, World w, BlockPos p, Vec3d start, Vec3d end) {
        BlockPos p2 = p.func_177972_a(s.func_177229_b(field_176387_N));
        IBlockState state1 = w.func_180495_p(p2);
        RayTraceResult trace = state1.func_177230_c().func_180636_a(state1, w, p2, start, end);
        return trace != null ? new RayTraceResult(trace.field_72313_a, trace.field_72307_f, trace.field_178784_b, p): trace;
    }

    @Override
    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        pos = pos.func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        return state1.func_177230_c().shouldCheckWeakPower(state1, world, pos, side);
    }

    @Override
    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        pos = pos.func_177972_a(blockState.func_177229_b(field_176387_N));
        IBlockState state1 = blockAccess.func_180495_p(pos);
        return state1.func_177230_c().func_176211_b(state1, blockAccess, pos, side);
    }

    @Override
    public boolean func_149744_f(IBlockState state) {
        if (state instanceof IExtendedBlockState) {
            return getValue((IExtendedBlockState) state, 0, 1) == 1;
        }
        return super.func_149744_f(state);
    }

    @Override
    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        pos = pos.func_177972_a(blockState.func_177229_b(field_176387_N));
        IBlockState state1 = blockAccess.func_180495_p(pos);
        return state1.func_177230_c().func_180656_a(state1, blockAccess, pos, side);
    }

    @Override
    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        pos = pos.func_177972_a(worldIn.func_180495_p(pos).func_177229_b(field_176387_N));
        IBlockState state1 = worldIn.func_180495_p(pos);
        state1.func_177230_c().func_176199_a(worldIn, pos, entityIn);
    }

    @Override
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        pos = pos.func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = worldIn.func_180495_p(pos);
        return state1.func_177230_c().func_185473_a(worldIn, pos, state1);
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        pos = pos.func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        return state1.func_177230_c().getPickBlock(state, target, world, pos, player);
    }

    @Override
    public boolean func_176214_u(IBlockState state) {
        return true;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @Override
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        pos = pos.func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        return state1.func_177230_c().getSoundType(state1, world, pos, entity);
    }

    @Override
    @SideOnly(Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        BlockPos pos = target.func_178782_a().func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = worldObj.func_180495_p(pos);
        RayTraceResult target1 = new RayTraceResult(target.field_72313_a, target.field_72307_f.func_178786_a(0, 1, 0), target.field_178784_b, pos);
        boolean flag = state1.func_177230_c().addHitEffects(state1, worldObj, target1, manager);
        if (!flag)
            Minecraft.func_71410_x().field_71452_i.func_180532_a(pos, target.field_178784_b);
        return true;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        pos = pos.func_177972_a(world.func_180495_p(pos).func_177229_b(field_176387_N));
        IBlockState state1 = world.func_180495_p(pos);
        boolean flag = state1.func_177230_c().addDestroyEffects(world, pos, manager);
        if (!flag)
            Minecraft.func_71410_x().field_71452_i.func_180533_a(pos, state1);
        return true;
    }

    @Override
    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        BlockPos pos = blockPosition.func_177972_a(state.func_177229_b(field_176387_N));
        IBlockState state1 = worldObj.func_180495_p(pos);
        boolean flag = state1.func_177230_c().addLandingEffects(state1, worldObj, pos, iblockstate, entity, numberOfParticles);
        if (!flag)
            worldObj.func_175739_a(EnumParticleTypes.BLOCK_DUST, blockPosition.func_177958_n() + 0.5, blockPosition.func_177956_o() + 1, blockPosition.func_177952_p() + 0.5, numberOfParticles, 0.0D, 0.0D, 0.0D, 0.15000000596046448D, Block.func_176210_f(state1));
        return true;
    }

    @Override
    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {}
}
