package se.gory_moon.horsepower.client.renderer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileEntityHPBaseRenderer<T extends TileEntity> extends TileEntitySpecialRenderer<T> {

    protected void renderItem(World world, ItemStack stack, float partialTicks) {
        RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
        if (stack != null) {
            GlStateManager.func_179137_b(0.5, 1, 0.5);
            EntityItem entityitem = new EntityItem(world, 0.0D, 0.0D, 0.0D, stack);
            entityitem.func_92059_d().func_190920_e(1);
            entityitem.field_70290_d = 0.0F;
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();

            float rotation = (float) (720.0 * (System.currentTimeMillis() & 0x3FFFL) / 0x3FFFL);

            GlStateManager.func_179114_b(rotation, 0.0F, 1.0F, 0);
            GlStateManager.func_179152_a(0.5F, 0.5F, 0.5F);
            GlStateManager.func_179123_a();
            RenderHelper.func_74519_b();
            itemRenderer.func_181564_a(entityitem.func_92059_d(), ItemCameraTransforms.TransformType.FIXED);
            RenderHelper.func_74518_a();
            GlStateManager.func_179099_b();

            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    /**
     * Gets the value between start and end according to pct
     */
    private double interpolateValue(double start, double end, double pct)
    {
        return start + (end - start) * pct;
    }

    protected void renderLeash(EntityCreature entity, double x, double y, double z, float entityYaw, float partialTicks, BlockPos pos) {
        if (entity != null)
        {
            y = y - (1.6D - 0.2D) * 0.5D;
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer vertexbuffer = tessellator.func_178180_c();
            double d2 = 0.0D;
            double d3 = 0.0D;
            double d4 = -1.0D;

            double d9 = this.interpolateValue(entity.field_70760_ar, entity.field_70761_aq, (double)partialTicks) * 0.01745329238474369D + (Math.PI / 2D);
            d2 = Math.cos(d9) * (double)entity.field_70130_N * 0.4D;
            d3 = Math.sin(d9) * (double)entity.field_70130_N * 0.4D;
            double d6 = (this.interpolateValue(entity.field_70169_q, entity.field_70165_t, (double)partialTicks)) + d2;
            double d7 = this.interpolateValue(entity.field_70167_r + entity.func_70047_e() * 1.1D, entity.field_70163_u + entity.func_70047_e() * 1.1D, (double)partialTicks) - d4 * 0.5D - 0.25D;
            double d8 = (this.interpolateValue(entity.field_70166_s, entity.field_70161_v, (double)partialTicks)) + d3;
            d2 = 0.5D;
            d3 = 0.5D;
            double d10 = pos.func_177958_n() + d2;
            double d11 = pos.func_177956_o();
            double d12 = pos.func_177952_p() + d3;
            x = x + d2;
            z = z + d3;
            double d13 = (double)((float)(d6 - d10));
            double d14 = (double)((float)(d7 - d11));
            double d15 = (double)((float)(d8 - d12));
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            GlStateManager.func_179129_p();

            vertexbuffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);

            for (int j = 0; j <= 24; ++j)
            {
                float f = 0.5F;
                float f1 = 0.4F;
                float f2 = 0.3F;

                if (j % 2 == 0)
                {
                    f *= 0.7F;
                    f1 *= 0.7F;
                    f2 *= 0.7F;
                }

                float f3 = (float)j / 24.0F;
                vertexbuffer.func_181662_b(x + d13 * (double)f3 + 0.0D, y + d14 * (double)(f3 * f3 + f3) * 0.5D + (double)((24.0F - (float)j) / 18.0F + 0.125F), z + d15 * (double)f3).func_181666_a(f, f1, f2, 1.0F).func_181675_d();
                vertexbuffer.func_181662_b(x + d13 * (double)f3 + 0.025D, y + d14 * (double)(f3 * f3 + f3) * 0.5D + (double)((24.0F - (float)j) / 18.0F + 0.125F) + 0.025D, z + d15 * (double)f3).func_181666_a(f, f1, f2, 1.0F).func_181675_d();
            }

            tessellator.func_78381_a();
            vertexbuffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);

            for (int k = 0; k <= 24; ++k)
            {
                float f4 = 0.5F;
                float f5 = 0.4F;
                float f6 = 0.3F;

                if (k % 2 == 0)
                {
                    f4 *= 0.7F;
                    f5 *= 0.7F;
                    f6 *= 0.7F;
                }

                float f7 = (float)k / 24.0F;
                vertexbuffer.func_181662_b(x + d13 * (double)f7 + 0.0D, y + d14 * (double)(f7 * f7 + f7) * 0.5D + (double)((24.0F - (float)k) / 18.0F + 0.125F) + 0.025D, z + d15 * (double)f7).func_181666_a(f4, f5, f6, 1.0F).func_181675_d();
                vertexbuffer.func_181662_b(x + d13 * (double)f7 + 0.025D, y + d14 * (double)(f7 * f7 + f7) * 0.5D + (double)((24.0F - (float)k) / 18.0F + 0.125F), z + d15 * (double)f7 + 0.025D).func_181666_a(f4, f5, f6, 1.0F).func_181675_d();
            }

            tessellator.func_78381_a();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
            GlStateManager.func_179089_o();
        }
    }

}
