/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import com.google.common.collect.Lists;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.recipes.GrindstoneRecipes;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;

public class TileEntityGrindstone
extends TileEntityHPBase {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{1};
    private int currentItemMillTime;
    private int totalItemMillTime;

    public TileEntityGrindstone() {
        super(2);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("millTime", this.currentItemMillTime);
        compound.func_74768_a("totalMillTime", this.totalItemMillTime);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (this.func_70301_a(0).func_190916_E() > 0) {
            this.currentItemMillTime = compound.func_74762_e("millTime");
            this.totalItemMillTime = compound.func_74762_e("totalMillTime");
        } else {
            this.currentItemMillTime = 0;
            this.totalItemMillTime = 1;
        }
    }

    public void func_70296_d() {
        if (this.func_70301_a(1).func_190926_b()) {
            BlockGrindstone.setState(false, this.field_145850_b, this.field_174879_c);
        }
        super.func_70296_d();
        this.notifyUpdate();
    }

    @Override
    public boolean validateArea() {
        if (this.searchPos == null) {
            this.searchPos = Lists.newArrayList();
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    if (x == 0 && z == 0) continue;
                    this.searchPos.add(this.func_174877_v().func_177982_a(x, 0, z));
                    this.searchPos.add(this.func_174877_v().func_177982_a(x, -1, z));
                }
            }
        }
        for (BlockPos pos : this.searchPos) {
            if (this.func_145831_w().func_175623_d(pos)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean targetReached() {
        ++this.currentItemMillTime;
        if (this.currentItemMillTime >= this.totalItemMillTime) {
            this.currentItemMillTime = 0;
            this.totalItemMillTime = GrindstoneRecipes.instance().getGrindstoneTime(this.func_70301_a(0));
            this.millItem();
            return true;
        }
        return false;
    }

    @Override
    public boolean canWork() {
        if (this.func_70301_a(0).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = GrindstoneRecipes.instance().getGrindstoneResult(this.func_70301_a(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack output = this.func_70301_a(1);
        if (output.func_190926_b()) {
            return true;
        }
        if (!output.func_77969_a(itemstack)) {
            return false;
        }
        int result = output.func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= output.func_77976_d();
    }

    private void millItem() {
        if (this.canWork()) {
            ItemStack input = this.func_70301_a(0);
            ItemStack result = GrindstoneRecipes.instance().getGrindstoneResult(this.func_70301_a(0));
            ItemStack output = this.func_70301_a(1);
            if (output.func_190926_b()) {
                this.func_70299_a(1, result.func_77946_l());
            } else if (output.func_77973_b() == result.func_77973_b()) {
                output.func_190917_f(result.func_190916_E());
            }
            input.func_190918_g(1);
            BlockGrindstone.setState(true, this.field_145850_b, this.field_174879_c);
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : new int[]{});
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        boolean flag;
        super.func_70299_a(index, stack);
        if (index == 1 && this.func_70301_a(1).func_190926_b()) {
            BlockGrindstone.setState(false, this.field_145850_b, this.field_174879_c);
            this.func_70296_d();
        }
        ItemStack itemstack = this.func_70301_a(index);
        boolean bl = flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        if (index == 0 && !flag) {
            this.totalItemMillTime = GrindstoneRecipes.instance().getGrindstoneTime(stack);
            this.currentItemMillTime = 0;
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 1 && index == 0 && GrindstoneRecipes.instance().hasRecipe(stack);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.totalItemMillTime;
            }
            case 1: {
                return this.currentItemMillTime;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.totalItemMillTime = value;
                break;
            }
            case 1: {
                this.currentItemMillTime = value;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 2;
    }

    public String func_70005_c_() {
        return "container.mill";
    }
}

