/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.blocks;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import se.gory_moon.horsepower.blocks.BlockChopper;
import se.gory_moon.horsepower.blocks.BlockFiller;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.items.ItemBlockChopper;
import se.gory_moon.horsepower.tileentity.TileEntityGrindstone;

public class ModBlocks {
    public static final BlockGrindstone BLOCK_GRINDSTONE = new BlockGrindstone();
    public static final BlockChopper BLOCK_CHOPPER = new BlockChopper();
    public static final BlockFiller BLOCK_CHOPPER_FILLER = (BlockFiller)new BlockFiller(Material.WOOD, "chopper_").setHardness(2.0f).setResistance(5.0f);

    public static void registerTileEntities() {
        ModBlocks.registerTileEntityNoPrefix(TileEntityGrindstone.class, TileEntityGrindstone.class.getSimpleName().replaceFirst("TileEntity", ""), "horsepower_grindstone_tilentity");
    }

    private static void registerTileEntity(Class<? extends TileEntity> tileEntityClass) {
        GameRegistry.registerTileEntity(tileEntityClass, (String)("horsepower:" + tileEntityClass.getSimpleName().replaceFirst("TileEntity", "")));
    }

    private static void registerTileEntity(Class<? extends TileEntity> tileEntityClass, String name, String legacyName) {
        GameRegistry.registerTileEntityWithAlternatives(tileEntityClass, (String)("horsepower:" + name), (String[])new String[]{"horsepower:" + legacyName});
    }

    private static void registerTileEntityNoPrefix(Class<? extends TileEntity> tileEntityClass, String name, String legacyName) {
        GameRegistry.registerTileEntityWithAlternatives(tileEntityClass, (String)("horsepower:" + name), (String[])new String[]{legacyName});
    }

    @Mod.EventBusSubscriber(modid="horsepower")
    public static class RegistrationHandler {
        public static final Set<ItemBlock> ITEM_BLOCKS = new HashSet<ItemBlock>();

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            Block[] blocks = new Block[]{BLOCK_GRINDSTONE, BLOCK_CHOPPER, BLOCK_CHOPPER_FILLER};
            registry.registerAll((IForgeRegistryEntry[])blocks);
        }

        @SubscribeEvent
        public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
            ItemBlock[] items = new ItemBlock[]{new ItemBlock((Block)BLOCK_GRINDSTONE), new ItemBlockChopper(BLOCK_CHOPPER)};
            IForgeRegistry registry = event.getRegistry();
            for (ItemBlock item : items) {
                registry.register(item.setRegistryName(item.getBlock().getRegistryName()));
                ITEM_BLOCKS.add(item);
            }
        }
    }
}

