/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.blocks;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.tileentity.TileEntityGrindstone;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;
import se.gory_moon.horsepower.util.Utils;

public abstract class BlockHPBase
extends Block {
    protected static boolean keepInventory = false;

    public BlockHPBase(Material materialIn) {
        super(materialIn);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public void onBlockHarvested(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityHPBase te;
        super.onBlockHarvested(worldIn, pos, state, player);
        if (!player.capabilities.isCreativeMode && !worldIn.isRemote && (te = this.getTileEntity(worldIn, pos)) != null) {
            InventoryHelper.dropInventoryItems((World)worldIn, (BlockPos)pos, (IInventory)te);
            if (te.hasWorker()) {
                InventoryHelper.spawnItemStack((World)worldIn, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), (ItemStack)new ItemStack(Items.LEAD));
            }
        }
    }

    private TileEntityHPBase getTileEntity(World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.getTileEntity(pos);
        return tileentity instanceof TileEntityHPBase ? (TileEntityHPBase)tileentity : null;
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity;
        if (!keepInventory && !worldIn.isRemote && (tileentity = worldIn.getTileEntity(pos)) instanceof TileEntityGrindstone) {
            worldIn.updateComparatorOutputLevel(pos, (Block)this);
        }
        super.breakBlock(worldIn, pos, state);
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack result;
        ItemStack stack = playerIn.getHeldItem(hand);
        TileEntityHPBase tileEntityHPBase = (TileEntityHPBase)worldIn.getTileEntity(pos);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        EntityCreature creature = null;
        ArrayList<Class<? extends EntityCreature>> clazzes = Utils.getCreatureClasses();
        block0: for (Class<? extends EntityCreature> clazz : clazzes) {
            for (Object entity : worldIn.getEntitiesWithinAABB(clazz, new AxisAlignedBB((double)x - 7.0, (double)y - 7.0, (double)z - 7.0, (double)x + 7.0, (double)y + 7.0, (double)z + 7.0))) {
                EntityCreature tmp;
                if (!(entity instanceof EntityCreature) || !(tmp = (EntityCreature)entity).getLeashed() || tmp.getLeashedToEntity() != playerIn) continue;
                creature = tmp;
                break block0;
            }
        }
        if (stack.getItem() instanceof ItemLead && creature != null || creature != null) {
            if (!tileEntityHPBase.hasWorker()) {
                creature.clearLeashed(true, false);
                tileEntityHPBase.setWorker(creature);
                return true;
            }
            return false;
        }
        if (!stack.isEmpty() && tileEntityHPBase.isItemValidForSlot(0, stack)) {
            ItemStack itemStack = tileEntityHPBase.getStackInSlot(0);
            boolean flag = false;
            if (itemStack.isEmpty()) {
                tileEntityHPBase.setInventorySlotContents(0, stack.copy());
                stack.setCount(0);
                flag = true;
            } else if (TileEntityHPBase.canCombine(itemStack, stack)) {
                int i = stack.getMaxStackSize() - itemStack.getCount();
                int j = Math.min(stack.getCount(), i);
                stack.shrink(j);
                itemStack.grow(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                return true;
            }
        }
        if ((result = tileEntityHPBase.removeStackFromSlot(1)).isEmpty() && stack.isEmpty() && hand != EnumHand.OFF_HAND) {
            result = tileEntityHPBase.removeStackFromSlot(0);
            BlockGrindstone.setState(false, worldIn, pos);
        }
        if (result.isEmpty()) {
            if (!stack.isEmpty()) {
                return false;
            }
            tileEntityHPBase.setWorkerToPlayer(playerIn);
        }
        if (stack.isEmpty()) {
            playerIn.setHeldItem(hand, result);
        } else if (playerIn.func_191521_c(result)) {
            playerIn.dropItem(result, false);
        }
        tileEntityHPBase.markDirty();
        return true;
    }
}

