/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.recipes.GrindstoneRecipes;
import se.gory_moon.horsepower.util.Localization;
import se.gory_moon.horsepower.util.Utils;

public class TileEntityGrindstone
extends TileEntity
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{1};
    private NonNullList<ItemStack> millItemStacks = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private static double[][] path = new double[][]{{-1.5, -1.5}, {0.0, -1.5}, {1.0, -1.5}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}, {-1.5, 1.0}, {-1.5, 0.0}};
    private AxisAlignedBB[] searchAreas = new AxisAlignedBB[8];
    private List<BlockPos> searchPos = null;
    private int origin;
    private int target = this.origin = -1;
    private boolean hasWorker = false;
    private EntityCreature worker;
    private NBTTagCompound nbtWorker;
    private int currentItemMillTime;
    private int totalItemMillTime;
    private boolean running = true;
    private boolean wasRunning = false;
    private boolean valid = false;
    private int validationTimer = 0;
    private IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    private IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);

    public void setWorker(EntityCreature newWorker) {
        this.hasWorker = true;
        this.worker = newWorker;
        this.worker.setHomePosAndDistance(this.pos, 3);
        this.target = this.getClosestTarget();
    }

    public void setWorkerToPlayer(EntityPlayer player) {
        if (this.hasWorker() && this.worker.canBeLeashedTo(player)) {
            this.hasWorker = false;
            this.worker.detachHome();
            this.worker.setLeashedToEntity((Entity)player, true);
            this.worker = null;
        }
    }

    public boolean hasWorker() {
        if (this.worker != null && !this.worker.isDead && !this.worker.getLeashed() && this.worker.getDistanceSq(this.pos) < 45.0) {
            return true;
        }
        if (this.worker != null) {
            this.worker = null;
            if (!this.getWorld().isRemote) {
                InventoryHelper.spawnItemStack((World)this.world, (double)this.pos.getX(), (double)(this.pos.getY() + 1), (double)this.pos.getZ(), (ItemStack)new ItemStack(Items.LEAD));
            }
        }
        this.hasWorker = false;
        return false;
    }

    public EntityCreature getWorker() {
        return this.worker;
    }

    @Nullable
    public ITextComponent getDisplayName() {
        if (this.valid) {
            return super.getDisplayName();
        }
        return new TextComponentTranslation(Localization.INFO.GRINDSTONE_INVALID.key(), new Object[0]).setStyle(new Style().setColor(TextFormatting.RED));
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        ItemStackHelper.saveAllItems((NBTTagCompound)compound, this.millItemStacks);
        compound.setInteger("millTime", this.currentItemMillTime);
        compound.setInteger("totalMillTime", this.totalItemMillTime);
        compound.setInteger("target", this.target);
        compound.setInteger("origin", this.origin);
        compound.setBoolean("hasWorker", this.hasWorker);
        if (this.worker != null) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            UUID uuid = this.worker.getUniqueID();
            nbtTagCompound.setUniqueId("UUID", uuid);
            compound.setTag("leash", (NBTBase)nbtTagCompound);
        }
        return super.writeToNBT(compound);
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.millItemStacks = NonNullList.withSize((int)this.getSizeInventory(), (Object)ItemStack.EMPTY);
        ItemStackHelper.loadAllItems((NBTTagCompound)compound, this.millItemStacks);
        if (this.getStackInSlot(0).getCount() > 0) {
            this.currentItemMillTime = compound.getInteger("millTime");
            this.totalItemMillTime = compound.getInteger("totalMillTime");
        } else {
            this.currentItemMillTime = 0;
            this.totalItemMillTime = 1;
        }
        this.target = compound.getInteger("target");
        this.origin = compound.getInteger("origin");
        this.hasWorker = compound.getBoolean("hasWorker");
        if (this.hasWorker && compound.hasKey("leash", 10)) {
            this.nbtWorker = compound.getCompoundTag("leash");
        }
    }

    public void notifyUpdate() {
        this.getWorld().notifyBlockUpdate(this.getPos(), this.getWorld().getBlockState(this.getPos()), this.getWorld().getBlockState(this.getPos()), 3);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.getBlock() != newState.getBlock();
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), -999, this.getUpdateTag());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.getNbtCompound());
    }

    public void markDirty() {
        if (((ItemStack)this.millItemStacks.get(1)).isEmpty()) {
            BlockGrindstone.setState(false, this.world, this.pos);
        }
        super.markDirty();
        this.notifyUpdate();
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.readFromNBT(tag);
        this.markDirty();
    }

    private boolean validateArea() {
        if (this.searchPos == null) {
            this.searchPos = Lists.newArrayList();
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    if (x == 0 && z == 0) continue;
                    this.searchPos.add(this.getPos().add(x, 0, z));
                    this.searchPos.add(this.getPos().add(x, -1, z));
                }
            }
        }
        for (BlockPos pos : this.searchPos) {
            if (this.getWorld().isAirBlock(pos)) continue;
            return false;
        }
        return true;
    }

    public void update() {
        boolean flag = false;
        --this.validationTimer;
        if (this.validationTimer <= 0) {
            this.valid = this.validateArea();
            this.validationTimer = this.valid ? 220 : 60;
        }
        if (this.nbtWorker != null) {
            if (this.hasWorker) {
                UUID uuid = this.nbtWorker.getUniqueId("UUID");
                int x = this.pos.getX();
                int y = this.pos.getY();
                int z = this.pos.getZ();
                ArrayList<Class<? extends EntityCreature>> clazzes = Utils.getCreatureClasses();
                block0: for (Class<? extends EntityCreature> clazz : clazzes) {
                    for (Object entity : this.world.getEntitiesWithinAABB(clazz, new AxisAlignedBB((double)x - 7.0, (double)y - 7.0, (double)z - 7.0, (double)x + 7.0, (double)y + 7.0, (double)z + 7.0))) {
                        EntityCreature creature;
                        if (!(entity instanceof EntityCreature) || !(creature = (EntityCreature)entity).getUniqueID().equals(uuid)) continue;
                        this.setWorker(creature);
                        break block0;
                    }
                }
            }
            this.nbtWorker = null;
        }
        if (!this.world.isRemote && this.valid) {
            if (!this.running && this.canMill()) {
                this.running = true;
            } else if (this.running && !this.canMill()) {
                this.running = false;
            }
            if (this.running != this.wasRunning) {
                this.target = this.getClosestTarget();
                this.wasRunning = this.running;
            }
            if (this.hasWorker() && this.running) {
                double x = (double)this.pos.getX() + path[this.target][0] * 2.0;
                double y = this.pos.getY() - 1;
                double z = (double)this.pos.getZ() + path[this.target][1] * 2.0;
                if (this.searchAreas[this.target] == null) {
                    this.searchAreas[this.target] = new AxisAlignedBB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5);
                }
                if (this.worker.getEntityBoundingBox().intersectsWith(this.searchAreas[this.target])) {
                    int next = this.target + 1;
                    int previous = this.target - 1;
                    if (next >= path.length) {
                        next = 0;
                    }
                    if (previous < 0) {
                        previous = path.length - 1;
                    }
                    if (this.origin != this.target && this.target != previous) {
                        this.origin = this.target;
                        ++this.currentItemMillTime;
                        if (this.currentItemMillTime == this.totalItemMillTime) {
                            this.currentItemMillTime = 0;
                            this.totalItemMillTime = GrindstoneRecipes.instance().getGrindstoneTime((ItemStack)this.millItemStacks.get(0));
                            this.millItem();
                            flag = true;
                        }
                    }
                    this.target = next;
                }
                if (this.worker instanceof AbstractHorse && ((AbstractHorse)this.worker).isEatingHaystack()) {
                    ((AbstractHorse)this.worker).setEatingHaystack(false);
                }
                if (this.target != -1 && this.worker.getNavigator().noPath()) {
                    x = (double)this.pos.getX() + path[this.target][0] * 2.0;
                    y = this.pos.getY() - 1;
                    z = (double)this.pos.getZ() + path[this.target][1] * 2.0;
                    this.worker.getNavigator().tryMoveToXYZ(x, y, z, 1.0);
                }
            }
        }
        if (flag) {
            this.markDirty();
        }
    }

    private int getClosestTarget() {
        if (this.hasWorker()) {
            double dist = Double.MAX_VALUE;
            int closest = 0;
            for (int i = 0; i < path.length; ++i) {
                double z;
                double y;
                double x = (double)this.pos.getX() + path[i][0] * 2.0;
                double tmp = this.worker.getDistance(x, y = (double)(this.pos.getY() - 1), z = (double)this.pos.getZ() + path[i][1] * 2.0);
                if (!(tmp < dist)) continue;
                dist = tmp;
                closest = i;
            }
            return closest;
        }
        return 0;
    }

    private void millItem() {
        if (this.canMill()) {
            ItemStack input = (ItemStack)this.millItemStacks.get(0);
            ItemStack result = GrindstoneRecipes.instance().getGrindstoneResult((ItemStack)this.millItemStacks.get(0));
            ItemStack output = (ItemStack)this.millItemStacks.get(1);
            if (output.isEmpty()) {
                this.millItemStacks.set(1, (Object)result.copy());
            } else if (output.getItem() == result.getItem()) {
                output.grow(result.getCount());
            }
            input.shrink(1);
            BlockGrindstone.setState(true, this.world, this.pos);
        }
    }

    private boolean canMill() {
        if (((ItemStack)this.millItemStacks.get(0)).isEmpty()) {
            return false;
        }
        ItemStack itemstack = GrindstoneRecipes.instance().getGrindstoneResult((ItemStack)this.millItemStacks.get(0));
        if (itemstack.isEmpty()) {
            return false;
        }
        ItemStack output = (ItemStack)this.millItemStacks.get(1);
        if (output.isEmpty()) {
            return true;
        }
        if (!output.isItemEqual(itemstack)) {
            return false;
        }
        int result = output.getCount() + itemstack.getCount();
        return result <= this.getInventoryStackLimit() && result <= output.getMaxStackSize();
    }

    public static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.getItem() == stack2.getItem() && stack1.getMetadata() == stack2.getMetadata() && stack1.getCount() <= stack1.getMaxStackSize() && ItemStack.areItemStackTagsEqual((ItemStack)stack1, (ItemStack)stack2);
    }

    public int[] getSlotsForFace(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : new int[]{});
    }

    public boolean canInsertItem(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.isItemValidForSlot(index, itemStackIn);
    }

    public boolean canExtractItem(int index, ItemStack stack, EnumFacing direction) {
        return direction == EnumFacing.DOWN && index == 1;
    }

    public int getSizeInventory() {
        return this.millItemStacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.millItemStacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getStackInSlot(int index) {
        return (ItemStack)this.millItemStacks.get(index);
    }

    public ItemStack decrStackSize(int index, int count) {
        ItemStack stack = ItemStackHelper.getAndSplit(this.millItemStacks, (int)index, (int)count);
        return stack;
    }

    public ItemStack removeStackFromSlot(int index) {
        ItemStack stack = ItemStackHelper.getAndRemove(this.millItemStacks, (int)index);
        return stack;
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.millItemStacks.get(index);
        boolean flag = !stack.isEmpty() && stack.isItemEqual(itemstack) && ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)itemstack);
        this.millItemStacks.set(index, (Object)stack);
        if (stack.getCount() > this.getInventoryStackLimit()) {
            stack.setCount(this.getInventoryStackLimit());
        }
        if (index == 1 && ((ItemStack)this.millItemStacks.get(1)).isEmpty()) {
            BlockGrindstone.setState(false, this.world, this.pos);
            this.markDirty();
        }
        if (index == 0 && !flag) {
            this.totalItemMillTime = GrindstoneRecipes.instance().getGrindstoneTime(stack);
            this.currentItemMillTime = 0;
            this.markDirty();
        }
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.world.getTileEntity(this.pos) == this && player.getDistanceSq((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) <= 64.0;
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return index != 1 && index == 0 && GrindstoneRecipes.instance().hasRecipe(stack);
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.totalItemMillTime;
            }
            case 1: {
                return this.currentItemMillTime;
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.totalItemMillTime = value;
                break;
            }
            case 1: {
                this.currentItemMillTime = value;
            }
        }
    }

    public int getFieldCount() {
        return 2;
    }

    public void clear() {
        this.millItemStacks.clear();
    }

    public String getName() {
        return "container.mill";
    }

    public boolean hasCustomName() {
        return false;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
        }
        return (T)super.getCapability(capability, facing);
    }
}

