/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoAccessor;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import se.gory_moon.horsepower.blocks.ModBlocks;
import se.gory_moon.horsepower.tileentity.TileEntityGrindstone;
import se.gory_moon.horsepower.util.Colors;
import se.gory_moon.horsepower.util.Localization;
import se.gory_moon.horsepower.util.Utils;

@Optional.Interface(iface="mcjty.theoneprobe.api.IProbeInfoAccessor", modid="theoneprobe")
public class BlockGrindstone
extends Block
implements IProbeInfoAccessor {
    private static boolean keepInventory = false;
    public static final PropertyBool FILLED = PropertyBool.create((String)"filled");
    private static final AxisAlignedBB COLLISION_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private static final AxisAlignedBB BOUNDING_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.8125, 1.0);

    public BlockGrindstone() {
        super(Material.ROCK);
        this.setHardness(1.5f);
        this.setResistance(10.0f);
        this.setSoundType(SoundType.STONE);
        this.setRegistryName("grindstone");
        this.setUnlocalizedName("grindstone");
        this.setCreativeTab(CreativeTabs.DECORATIONS);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_AABB;
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return COLLISION_AABB;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityGrindstone();
    }

    public void onBlockHarvested(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityGrindstone te;
        super.onBlockHarvested(worldIn, pos, state, player);
        if (!player.capabilities.isCreativeMode && !worldIn.isRemote && (te = this.getTileEntity(worldIn, pos)) != null) {
            InventoryHelper.dropInventoryItems((World)worldIn, (BlockPos)pos, (IInventory)te);
            if (te.hasWorker()) {
                InventoryHelper.spawnItemStack((World)worldIn, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), (ItemStack)new ItemStack(Items.LEAD));
            }
        }
    }

    private TileEntityGrindstone getTileEntity(World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.getTileEntity(pos);
        return tileentity instanceof TileEntityGrindstone ? (TileEntityGrindstone)tileentity : null;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{FILLED});
    }

    public int getMetaFromState(IBlockState state) {
        return (Boolean)state.getValue((IProperty)FILLED) != false ? 1 : 0;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)FILLED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return super.getActualState(state, worldIn, pos);
    }

    public static void setState(boolean filled, World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.getTileEntity(pos);
        keepInventory = true;
        worldIn.setBlockState(pos, ModBlocks.BLOCK_GRINDSTONE.getDefaultState().withProperty((IProperty)FILLED, (Comparable)Boolean.valueOf(filled)), 3);
        keepInventory = false;
        if (tileentity != null) {
            tileentity.validate();
            worldIn.setTileEntity(pos, tileentity);
            tileentity.validate();
        }
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity;
        if (!keepInventory && !worldIn.isRemote && (tileentity = worldIn.getTileEntity(pos)) instanceof TileEntityGrindstone) {
            worldIn.updateComparatorOutputLevel(pos, (Block)this);
        }
        super.breakBlock(worldIn, pos, state);
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack result;
        ItemStack stack = playerIn.getHeldItem(hand);
        TileEntityGrindstone tileEntityGrindstone = (TileEntityGrindstone)worldIn.getTileEntity(pos);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        EntityCreature creature = null;
        ArrayList<Class<? extends EntityCreature>> clazzes = Utils.getCreatureClasses();
        block0: for (Class<? extends EntityCreature> clazz : clazzes) {
            for (Object entity : worldIn.getEntitiesWithinAABB(clazz, new AxisAlignedBB((double)x - 7.0, (double)y - 7.0, (double)z - 7.0, (double)x + 7.0, (double)y + 7.0, (double)z + 7.0))) {
                EntityCreature tmp;
                if (!(entity instanceof EntityCreature) || !(tmp = (EntityCreature)entity).getLeashed() || tmp.getLeashedToEntity() != playerIn) continue;
                creature = tmp;
                break block0;
            }
        }
        if (stack.getItem() instanceof ItemLead && creature != null || creature != null) {
            if (!tileEntityGrindstone.hasWorker()) {
                creature.clearLeashed(true, false);
                tileEntityGrindstone.setWorker(creature);
                return true;
            }
            return false;
        }
        if (!stack.isEmpty() && tileEntityGrindstone.isItemValidForSlot(0, stack)) {
            ItemStack itemStack = tileEntityGrindstone.getStackInSlot(0);
            boolean flag = false;
            if (itemStack.isEmpty()) {
                tileEntityGrindstone.setInventorySlotContents(0, stack.copy());
                stack.setCount(0);
                flag = true;
            } else if (TileEntityGrindstone.canCombine(itemStack, stack)) {
                int i = stack.getMaxStackSize() - itemStack.getCount();
                int j = Math.min(stack.getCount(), i);
                stack.shrink(j);
                itemStack.grow(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                return true;
            }
        }
        if ((result = tileEntityGrindstone.removeStackFromSlot(1)).isEmpty() && stack.isEmpty() && hand != EnumHand.OFF_HAND) {
            result = tileEntityGrindstone.removeStackFromSlot(0);
            BlockGrindstone.setState(false, worldIn, pos);
        }
        if (result.isEmpty()) {
            if (!stack.isEmpty()) {
                return false;
            }
            tileEntityGrindstone.setWorkerToPlayer(playerIn);
        }
        if (stack.isEmpty()) {
            playerIn.setHeldItem(hand, result);
        } else if (playerIn.func_191521_c(result)) {
            playerIn.dropItem(result, false);
        }
        tileEntityGrindstone.markDirty();
        return true;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add(Localization.ITEM.MILL.SIZE.translate(Colors.WHITE.toString(), Colors.LIGHTGRAY.toString()));
        tooltip.add(Localization.ITEM.MILL.LOCATION.translate(Colors.WHITE.toString(), Colors.LIGHTGRAY.toString()));
        tooltip.add(Localization.ITEM.MILL.USE.translate(new String[0]));
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tileEntity = world.getTileEntity(data.getPos());
        if (tileEntity instanceof TileEntityGrindstone) {
            TileEntityGrindstone te = (TileEntityGrindstone)tileEntity;
            probeInfo.progress((long)((double)te.getField(1) / (double)te.getField(0) * 100.0), 100L, (IProgressStyle)new ProgressStyle().suffix("%"));
        }
    }
}

