/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.passive.AbstractHorse;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HorsePowerMod;

public class Utils {
    public static ArrayList<Class<? extends EntityCreature>> getCreatureClasses() {
        ArrayList clazzes = Lists.newArrayList();
        if (Configs.useHorseInterface) {
            clazzes.add(AbstractHorse.class);
        }
        for (String e : Configs.grindstoneModList) {
            try {
                Class<?> clazz = Class.forName(e);
                if (EntityCreature.class.isAssignableFrom(clazz)) {
                    clazzes.add(clazz);
                    continue;
                }
                HorsePowerMod.logger.error("Error in config, the mob (" + e + ") can't be leashed");
            }
            catch (ClassNotFoundException e1) {
                HorsePowerMod.logger.error("Error in config, could not find (" + e + ") mob class");
            }
        }
        return clazzes;
    }
}

