/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.recipes;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.server.FMLServerHandler;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.recipes.ChopperRecipe;
import se.gory_moon.horsepower.recipes.GrindstoneRecipe;

public class HPRecipes {
    private static HPRecipes INSTANCE = new HPRecipes();
    private final ArrayList<GrindstoneRecipe> grindstoneRecipes = Lists.newArrayList();
    private final ArrayList<ChopperRecipe> chopperRecipes = Lists.newArrayList();

    public static HPRecipes instance() {
        return INSTANCE;
    }

    private HPRecipes() {
    }

    public void reloadRecipes(ICommandSender sender) {
        Object text;
        ItemStack in;
        Object stack;
        int time;
        ArrayList stacks;
        Object[] comp;
        int i;
        HorsePowerMod.jeiPlugin.removeRecipe();
        this.grindstoneRecipes.clear();
        this.chopperRecipes.clear();
        for (i = 0; i < Configs.grindstoneRecipes.length; ++i) {
            comp = Configs.grindstoneRecipes[i].split("-");
            stacks = Lists.newArrayList();
            time = -1;
            for (String string : comp) {
                if (string.contains(":")) {
                    stack = this.parseItemStack(string);
                    if ((!(stack instanceof ItemStack) || ((ItemStack)stack).func_190926_b()) && (stack instanceof ItemStack || stack == null)) continue;
                    stacks.add(stack);
                    continue;
                }
                if (stacks.size() != 2) continue;
                try {
                    time = Integer.parseInt(string);
                }
                catch (NumberFormatException e) {
                    HorsePowerMod.logger.error("Parse error with grindstone time '" + string + "' in config for input " + stacks.get(0) + " and output " + stacks.get(1) + ".");
                    time = -1;
                }
            }
            if (stacks.size() == 2 && time > -1) {
                if (stacks.get(0) instanceof List) {
                    for (Object stack2 : (List)stacks.get(0)) {
                        ItemStack in2 = (ItemStack)stack2;
                        in2.func_190920_e(1);
                        this.addGrindstoneRecipe(in2, (ItemStack)stacks.get(1), time);
                    }
                    continue;
                }
                in = (ItemStack)stacks.get(0);
                in.func_190920_e(1);
                this.addGrindstoneRecipe(in, (ItemStack)stacks.get(1), time);
                continue;
            }
            text = "Couldn't load grindstone recipe " + Joiner.on((String)"-").join(comp) + ")";
            HorsePowerMod.logger.warn((String)text);
            this.sendMessage(sender, (String)text);
        }
        for (i = 0; i < Configs.choppingRecipes.length; ++i) {
            comp = Configs.choppingRecipes[i].split("-");
            stacks = Lists.newArrayList();
            time = -1;
            for (String string : comp) {
                if (string.contains(":")) {
                    stack = this.parseItemStack(string);
                    if ((!(stack instanceof ItemStack) || ((ItemStack)stack).func_190926_b()) && (stack instanceof ItemStack || stack == null)) continue;
                    stacks.add(stack);
                    continue;
                }
                if (stacks.size() != 2) continue;
                try {
                    time = Integer.parseInt(string);
                }
                catch (NumberFormatException e) {
                    HorsePowerMod.logger.error("Parse error with chopping time '" + string + "' in config for input " + stacks.get(0) + " and output " + stacks.get(1) + ".");
                    time = -1;
                }
            }
            if (stacks.size() == 2 && time > -1) {
                if (stacks.get(0) instanceof List) {
                    for (Object stack3 : (List)stacks.get(0)) {
                        ItemStack in3 = (ItemStack)stack3;
                        in3.func_190920_e(1);
                        this.addChoppingRecipe(in3, (ItemStack)stacks.get(1), time);
                    }
                    continue;
                }
                in = (ItemStack)stacks.get(0);
                in.func_190920_e(1);
                this.addChoppingRecipe(in, (ItemStack)stacks.get(1), time);
                continue;
            }
            text = "Couldn't load chopping recipe (" + Joiner.on((String)"-").join(comp) + ")";
            HorsePowerMod.logger.warn((String)text);
            this.sendMessage(sender, (String)text);
        }
        HorsePowerMod.jeiPlugin.addRecipes();
        HorsePowerMod.tweakerPlugin.applyTweaker();
    }

    private void sendMessage(ICommandSender sender, String message) {
        if (sender != null) {
            if (sender instanceof EntityPlayer || sender instanceof RConConsoleSource || sender instanceof CommandBlockBaseLogic) {
                sender.func_145747_a((ITextComponent)new TextComponentString(message));
            } else if (sender.func_70005_c_().equals("Server")) {
                FMLServerHandler.instance().getServer().func_145747_a((ITextComponent)new TextComponentString(message));
            }
        }
    }

    private Object parseItemStack(String item) {
        int meta;
        int amount;
        String[] data = item.split("@");
        int n = amount = data.length == 1 ? 1 : Integer.parseInt(data[1]);
        if (data.length == 2) {
            item = item.substring(0, item.indexOf("@"));
        }
        int n2 = (data = item.split(":")).length == 2 ? 0 : (meta = "*".equals(data[2]) ? Short.MAX_VALUE : Integer.parseInt(data[2]));
        if (item.startsWith("ore:")) {
            NonNullList items = OreDictionary.getOres((String)item.substring(4));
            return items;
        }
        Item item1 = Item.func_111206_d((String)(data[0] + ":" + data[1]));
        if (item1 == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack(item1, amount, meta);
        return stack;
    }

    public void addGrindstoneRecipe(Block input, ItemStack output, int time) {
        this.addGrindstoneRecipe(Item.func_150898_a((Block)input), output, time);
    }

    public void addGrindstoneRecipe(Item input, ItemStack output, int time) {
        this.addGrindstoneRecipe(new ItemStack(input, 1, Short.MAX_VALUE), output, time);
    }

    public void addGrindstoneRecipe(ItemStack input, ItemStack output, int time) {
        if (this.getGrindstoneResult(input) != ItemStack.field_190927_a) {
            return;
        }
        this.grindstoneRecipes.add(new GrindstoneRecipe(input, output, time));
    }

    public void addGrindstoneRecipe(GrindstoneRecipe recipe) {
        if (this.getGrindstoneResult(recipe.getInput()) != ItemStack.field_190927_a) {
            return;
        }
        this.grindstoneRecipes.add(recipe);
    }

    public void addChoppingRecipe(Block input, ItemStack output, int time) {
        this.addChoppingRecipe(Item.func_150898_a((Block)input), output, time);
    }

    public void addChoppingRecipe(Item input, ItemStack output, int time) {
        this.addChoppingRecipe(new ItemStack(input, 1, Short.MAX_VALUE), output, time);
    }

    public void addChoppingRecipe(ItemStack input, ItemStack output, int time) {
        if (this.getChopperResult(input) != ItemStack.field_190927_a) {
            return;
        }
        this.chopperRecipes.add(new ChopperRecipe(input, output, time));
    }

    public void addChoppingRecipe(ChopperRecipe recipe) {
        if (this.getChopperResult(recipe.getInput()) != ItemStack.field_190927_a) {
            return;
        }
        this.chopperRecipes.add(recipe);
    }

    public void removeGrindstoneRecipe(GrindstoneRecipe recipe) {
        if (this.hasGrindstoneRecipe(recipe.getInput())) {
            this.grindstoneRecipes.remove(recipe);
        }
    }

    public void removeGrindstoneRecipe(ItemStack input) {
        if (this.hasGrindstoneRecipe(input)) {
            for (GrindstoneRecipe recipe : this.grindstoneRecipes) {
                if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)input, (boolean)false)) continue;
                this.grindstoneRecipes.remove(recipe);
            }
        }
    }

    public void removeChoppingRecipe(ChopperRecipe recipe) {
        if (this.hasChopperRecipe(recipe.getInput())) {
            this.chopperRecipes.remove(recipe);
        }
    }

    public void removeChoppingRecipe(ItemStack input) {
        if (this.hasChopperRecipe(input)) {
            for (ChopperRecipe recipe : this.chopperRecipes) {
                if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)input, (boolean)false)) continue;
                this.chopperRecipes.remove(recipe);
            }
        }
    }

    public ItemStack getGrindstoneResult(ItemStack stack) {
        for (GrindstoneRecipe recipe : this.grindstoneRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe.getOutput();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getChopperResult(ItemStack stack) {
        for (ChopperRecipe recipe : this.chopperRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe.getOutput();
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasGrindstoneRecipe(ItemStack stack) {
        for (GrindstoneRecipe recipe : this.grindstoneRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChopperRecipe(ItemStack stack) {
        for (ChopperRecipe recipe : this.chopperRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<GrindstoneRecipe> getGrindstoneRecipes() {
        return this.grindstoneRecipes;
    }

    public ArrayList<ChopperRecipe> getChoppingRecipes() {
        return this.chopperRecipes;
    }

    public int getGrindstoneTime(ItemStack stack) {
        for (GrindstoneRecipe recipe : this.grindstoneRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe.getTime();
        }
        return 16;
    }

    public int getChoppingTime(ItemStack stack) {
        for (ChopperRecipe recipe : this.chopperRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe.getTime();
        }
        return 1;
    }
}

