/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.globalgamerules.config;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Config
extends Configuration {
    public static final String CATEGORY_GAMERULES = "gamerules";
    public HashMap<String, Boolean> rules = new HashMap();
    public HashMap<String, Boolean> defaults;
    public HashMap<String, String> comments = new HashMap();

    public Config(File name) {
        super(name);
        this.rules.put("commandBlockOutput", true);
        this.rules.put("doDaylightCycle", true);
        this.rules.put("doFireTick", true);
        this.rules.put("doMobLoot", true);
        this.rules.put("doMobSpawning", true);
        this.rules.put("keepInventory", false);
        this.rules.put("mobGriefing", true);
        this.rules.put("naturalRegeneration", true);
        this.comments.put("commandBlockOutput", "Whether command blocks should notify admins when they perform commands");
        this.comments.put("doDaylightCycle", "Whether time progresses");
        this.comments.put("doFireTick", "Whether fire should spread and naturally extinguish");
        this.comments.put("doMobLoot", "Whether mobs should drop items");
        this.comments.put("doMobSpawning", "Whether mobs should naturally spawn");
        this.comments.put("keepInventory", "Whether the player should keep items in their inventory after death");
        this.comments.put("mobGriefing", "Whether creepers, zombies, endermen, ghasts, withers, rabbits, sheep, and villagers should be able to change blocks and whether villagers, zombies, skeletons, and zombie pigmen can pick up items");
        this.comments.put("naturalRegeneration", "Whether the player can regenerate health naturally if their hunger is full enough (doesn't affect external healing, such as golden apples, the Regeneration effect, etc.)");
        this.addCustomCategoryComment(CATEGORY_GAMERULES, "Set the values to 'true' or 'false' depending if you want to have the GameRule enabled or disabled");
        this.defaults = (HashMap)this.rules.clone();
    }

    public Config loadConfig() {
        this.load();
        this.syncConfigs();
        return this;
    }

    public void saveConfig() {
        ConfigCategory cat = this.getCategory(CATEGORY_GAMERULES);
        for (Map.Entry<String, Boolean> entry : this.rules.entrySet()) {
            String rule = entry.getKey();
            Boolean state = entry.getValue();
            Property prop = cat.get(rule);
            prop.setValue(state.booleanValue());
            cat.put(rule, prop);
        }
        if (this.hasChanged()) {
            this.save();
        }
    }

    public void syncConfigs() {
        for (Map.Entry<String, Boolean> entry : this.rules.entrySet()) {
            String rule = entry.getKey();
            Boolean state = this.get(CATEGORY_GAMERULES, rule, this.defaults.get(rule), this.comments.get(rule)).getBoolean();
            this.rules.put(rule, state);
        }
        if (this.hasChanged()) {
            this.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("GlobalGameRules")) {
            this.syncConfigs();
        }
    }
}

