/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.globalgamerules;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.gory_moon.globalgamerules.GGRConfig;

public class WorldEvents {
    public static final Logger LOGGER = LogManager.getLogger((String)"GlobalGameRules");

    @SubscribeEvent
    public static void onWorldJoin(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof PlayerEntity) {
            World world = event.getWorld();
            MinecraftServer server = world.func_73046_m();
            PlayerEntity player = (PlayerEntity)event.getEntity();
            if (server != null) {
                ((List)GGRConfig.COMMON.defaultCommands.get()).forEach(s -> {
                    String command = s.replaceAll("@p", player.func_146103_bH().getName());
                    server.func_195571_aL().func_197059_a(server.func_195573_aM(), command);
                });
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().func_201670_d()) {
            return;
        }
        IWorld world = event.getWorld();
        WorldInfo info = world.func_72912_H();
        GameRules rules = info.func_82574_x();
        LOGGER.info("Applying config gamerules to dimension {} ({})", (Object)world.func_201675_m().func_186058_p().func_186068_a(), (Object)info.func_76065_j());
        HashMap arguments = new HashMap();
        GGRConfig.COMMON.gameRules.forEach((ruleKey, configValue) -> arguments.put(ruleKey.func_223576_a(), new ParsedArgument(0, 0, configValue.get())));
        CommandContext context = new CommandContext((Object)world.func_201672_e().func_73046_m().func_195573_aM(), null, arguments, null, null, null, null, null, null, false);
        GGRConfig.COMMON.gameRules.forEach((ruleKey, configValue) -> rules.func_223585_a(ruleKey).func_223554_b(context, ruleKey.func_223576_a()));
        if (!info.func_176123_z() && ((Boolean)GGRConfig.COMMON.setDifficulty.get()).booleanValue()) {
            Difficulty diff = (Difficulty)GGRConfig.COMMON.difficulty.get();
            info.func_176144_a(diff);
            LOGGER.info("Setting difficulty of dimension {} ({}) to {}", (Object)world.func_201675_m().func_186058_p().func_186068_a(), (Object)info.func_76065_j(), (Object)diff.toString());
        }
        if (!info.func_176123_z()) {
            Boolean hardcore = (Boolean)GGRConfig.COMMON.hardcore.get();
            info.func_176119_g(hardcore.booleanValue());
            if (hardcore.booleanValue() && info.func_176130_y() != Difficulty.HARD) {
                info.func_176144_a(Difficulty.HARD);
            }
            if (hardcore.booleanValue()) {
                LOGGER.info("Setting dimension {} ({}) to hardcore", (Object)world.func_201675_m().func_186058_p().func_186068_a(), (Object)info.func_76065_j());
            }
        }
        if (((Boolean)GGRConfig.COMMON.lockDifficulty.get()).booleanValue()) {
            info.func_180783_e(true);
            LOGGER.info("Locking difficulty of dimension {} ({})", (Object)world.func_201675_m().func_186058_p().func_186068_a(), (Object)info.func_76065_j());
        }
    }

    @SubscribeEvent
    public static void onWorldUnLoad(WorldEvent.Unload event) {
        if (event.getWorld().func_201670_d()) {
            return;
        }
        IWorld world = event.getWorld();
        WorldInfo info = world.func_72912_H();
        GameRules rules = info.func_82574_x();
        if (((Boolean)GGRConfig.COMMON.saveGameRules.get()).booleanValue()) {
            GGRConfig.COMMON.gameRules.forEach((ruleKey, configValue) -> {
                GameRules.RuleValue val = rules.func_223585_a(ruleKey);
                if (val instanceof GameRules.BooleanValue) {
                    ((ForgeConfigSpec.BooleanValue)configValue).set((Object)((GameRules.BooleanValue)val).func_223572_a());
                } else if (val instanceof GameRules.IntegerValue) {
                    ((ForgeConfigSpec.IntValue)configValue).set((Object)((GameRules.IntegerValue)val).func_223560_a());
                }
            });
        }
        if (((Boolean)GGRConfig.COMMON.setDifficulty.get()).booleanValue() && !event.getWorld().func_72912_H().func_176123_z()) {
            GGRConfig.COMMON.difficulty.set((Object)info.func_176130_y());
        }
        GGRConfig.commonSpec.save();
    }
}

