package se.gory_moon.globalgamerules;

import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import se.gory_moon.globalgamerules.config.Config;
import se.gory_moon.globalgamerules.reference.Reference;

import java.util.Map;

public class WorldEvents {

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        WorldInfo info = world.func_72912_H();
        GameRules gRules = world.func_82736_K();

        Reference.logger.info("Applying config gamerules to dimension {} ({})", getDimensionId(world), info.func_76065_j());
        for (Map.Entry<String, Config.Value> entry : GlobalGR.getConfig().rules.entrySet()) {
            String rule = entry.getKey();
            Config.Value state = entry.getValue();
            gRules.func_82764_b(rule, state.getStringValue());
        }

        if (!event.getWorld().field_72995_K && !info.func_176123_z()) {
            int diff = GlobalGR.getConfig().misc.get(Config.MISC_WORLDDIFFICULTY).getIntegerValue();
            if (diff != -1) {
                info.func_176144_a(EnumDifficulty.func_151523_a(diff));
                Reference.logger.info("Setting difficulty of dimension {} ({}) to {}", getDimensionId(world), info.func_76065_j(),
                        EnumDifficulty.func_151523_a(diff).toString());
            }

            if (GlobalGR.getConfig().misc.get(Config.MISC_WORLDDIFFICULTYLOCK).getBooleanValue()) {
                info.func_180783_e(true);
                Reference.logger.info("Locking difficulty of dimension {} ({})", getDimensionId(world), info.func_76065_j());
            }
        }
    }

    private int getDimensionId(World world) {
        for (Integer i : DimensionManager.getIDs()) {
            if (DimensionManager.getWorld(i).equals(world))
                return i;
        }
        return 0;
    }

    @SubscribeEvent
    public void onWorldUnLoad(WorldEvent.Unload event) {
        World world = event.getWorld();
        WorldInfo info = world.func_72912_H();
        GameRules gRules = event.getWorld().func_82736_K();

        Reference.logger.info("Saving gamerules of dimension {} ({}) to config",
                getDimensionId(world), info.func_76065_j());
        for (Map.Entry<String, Config.Value> entry : GlobalGR.getConfig().rules.entrySet()) {
            String rule = entry.getKey();
            Config.Value value = entry.getValue();
            String state = gRules.func_82767_a(rule);

            GlobalGR.getConfig().rules.put(rule, new Config.Value(state, value.getType()));
        }

        if (!event.getWorld().field_72995_K && GlobalGR.getConfig().misc.get(Config.MISC_WORLDDIFFICULTY).getIntegerValue() != -1) {
            Config.Value val = GlobalGR.getConfig().misc.get(Config.MISC_WORLDDIFFICULTY);
            Config.Value newVal = new Config.Value(String.valueOf(info.func_176130_y().func_151525_a()), val.getType(), val.getShowInGui());
            GlobalGR.getConfig().misc.put(Config.MISC_WORLDDIFFICULTY, newVal);
        }

        GlobalGR.getConfig().saveConfig();
    }

}
