/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.tile;

import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import se.gory_moon.chargers.Configs;
import se.gory_moon.chargers.handler.WirelessHandler;
import se.gory_moon.chargers.network.PacketHandler;
import se.gory_moon.chargers.power.CustomEnergyStorage;
import se.gory_moon.chargers.tile.TileEntityEnergyHolder;

public class TileEntityWirelessCharger
extends TileEntityEnergyHolder {
    private boolean registered = false;
    private int lastPowered = -1;
    private int availableEnergy;

    public TileEntityWirelessCharger() {
        this.storage = new CustomEnergyStorage(Configs.chargers.wireless.wirelessStorage, Configs.chargers.wireless.wirelessMaxInput, Configs.chargers.wireless.wirelessMaxOutput);
    }

    public void func_145843_s() {
        super.func_145843_s();
        WirelessHandler.INSTANCE.unRegister(this);
        this.registered = false;
    }

    public void func_70296_d() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 2);
        super.func_70296_d();
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !this.registered) {
            WirelessHandler.INSTANCE.register(this);
            this.registered = true;
        }
        super.func_73660_a();
        if (this.lastPowered == -1 || this.lastPowered == 0 && this.storage.getEnergyStored() > 0 || this.lastPowered > 0 && this.storage.getEnergyStored() == 0) {
            if (this.field_145850_b.field_72995_K) {
                PacketHandler.sendToAllAround(this.func_189518_D_(), this);
            }
            this.lastPowered = this.storage.getEnergyStored();
            this.func_70296_d();
        }
    }

    public void updateAvailable() {
        this.availableEnergy = Math.min(this.storage.getMaxOutput(), this.storage.getEnergyStored());
    }

    public boolean chargeItems(NonNullList<ItemStack> items) {
        boolean charged = false;
        for (int i = 0; i < items.size() && this.availableEnergy > 0; ++i) {
            int transferred;
            IEnergyStorage energyStorage;
            ItemStack stack = (ItemStack)items.get(i);
            if (stack.func_190926_b() || !stack.hasCapability(CapabilityEnergy.ENERGY, null) || (energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) == null || stack.func_190916_E() != 1 || (transferred = energyStorage.receiveEnergy(this.availableEnergy, false)) <= 0) continue;
            this.storage.extractEnergy(transferred, false);
            this.availableEnergy -= transferred;
            charged = true;
        }
        return charged;
    }

    public boolean canCharge() {
        return this.storage.getEnergyStored() > 0 && !this.isPowered();
    }

    public boolean isPowered() {
        return this.field_145850_b.func_175667_e(this.func_174877_v()) && this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
    }
}

