/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.tile;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import se.gory_moon.chargers.power.CustomEnergyStorage;

public abstract class TileEntityEnergyHolder
extends TileEntity
implements ITickable {
    public CustomEnergyStorage storage;

    public float getEnergyDiff() {
        return this.storage.getAverageChange();
    }

    public void update() {
        this.storage.tick();
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.storage.readFromNBT(compound);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        return this.storage.writeToNBT(super.writeToNBT(compound));
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.pos, -1, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.getNbtCompound());
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.readFromNBT(tag);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.storage);
        }
        return (T)super.getCapability(capability, facing);
    }
}

