/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.tile;

import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import se.gory_moon.chargers.Configs;
import se.gory_moon.chargers.handler.WirelessHandler;
import se.gory_moon.chargers.network.PacketHandler;
import se.gory_moon.chargers.power.CustomEnergyStorage;
import se.gory_moon.chargers.tile.TileEntityEnergyHolder;

public class TileEntityWirelessCharger
extends TileEntityEnergyHolder {
    private boolean registered = false;
    private int lastPowered = -1;
    private int availableEnergy;

    public TileEntityWirelessCharger() {
        this.storage = new CustomEnergyStorage(Configs.chargers.wireless.wirelessStorage, Configs.chargers.wireless.wirelessMaxInput, Configs.chargers.wireless.wirelessMaxOutput);
    }

    public void invalidate() {
        super.invalidate();
        WirelessHandler.INSTANCE.unRegister(this);
        this.registered = false;
    }

    public void markDirty() {
        IBlockState state = this.getWorld().getBlockState(this.getPos());
        this.getWorld().notifyBlockUpdate(this.getPos(), state, state, 2);
        super.markDirty();
    }

    @Override
    public void update() {
        if (!this.world.isRemote && !this.registered) {
            WirelessHandler.INSTANCE.register(this);
            this.registered = true;
        }
        super.update();
        if (this.lastPowered == -1 || this.lastPowered == 0 && this.storage.getEnergyStored() > 0 || this.lastPowered > 0 && this.storage.getEnergyStored() == 0) {
            if (this.world.isRemote) {
                PacketHandler.sendToAllAround(this.getUpdatePacket(), this);
            }
            this.lastPowered = this.storage.getEnergyStored();
            this.markDirty();
        }
    }

    public void updateAvailable() {
        this.availableEnergy = Math.min(this.storage.getMaxOutput(), this.storage.getEnergyStored());
    }

    public boolean chargeItems(NonNullList<ItemStack> items) {
        boolean charged = false;
        for (int i = 0; i < items.size() && this.availableEnergy > 0; ++i) {
            int transferred;
            IEnergyStorage energyStorage;
            ItemStack stack = (ItemStack)items.get(i);
            if (stack.isEmpty() || !stack.hasCapability(CapabilityEnergy.ENERGY, null) || (energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) == null || stack.getCount() != 1 || (transferred = energyStorage.receiveEnergy(this.availableEnergy, false)) <= 0) continue;
            this.storage.extractEnergy(transferred, false);
            this.availableEnergy -= transferred;
            charged = true;
        }
        return charged;
    }

    public boolean canCharge() {
        return this.storage.getEnergyStored() > 0 && !this.isPowered();
    }

    public boolean isPowered() {
        return this.world.isBlockLoaded(this.getPos()) && this.world.getRedstonePowerFromNeighbors(this.getPos()) > 0;
    }
}

