/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.tile;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;

public class CustomItemStackHandler
extends ItemStackHandler {
    private int size;

    public CustomItemStackHandler(int size) {
        super(NonNullList.withSize((int)size, (Object)ItemStack.EMPTY));
        this.size = size;
    }

    public void setSize(int size) {
        this.stacks = NonNullList.withSize((int)this.size, (Object)ItemStack.EMPTY);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (!stack.isEmpty() && stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            return storage != null && storage.receiveEnergy(1, true) > 0;
        }
        return false;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot == 0 && this.isItemValid(slot, stack)) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == 0) {
            return ItemStack.EMPTY;
        }
        return super.extractItem(slot, amount, simulate);
    }

    public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }
}

