/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.tile;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import se.gory_moon.chargers.Configs;
import se.gory_moon.chargers.handler.WirelessHandler;
import se.gory_moon.chargers.network.MessageUpdatePower;
import se.gory_moon.chargers.network.PacketHandler;
import se.gory_moon.chargers.tile.CustomEnergyStorage;

public class TileEntityWirelessCharger
extends TileEntity
implements ITickable {
    public CustomEnergyStorage storage;
    private boolean registered = false;
    private int lastPowered = -1;

    public TileEntityWirelessCharger() {
        this.storage = new CustomEnergyStorage(Configs.chargers.wireless.wirelessStorage, Configs.chargers.wireless.wirelessMaxInput, Configs.chargers.wireless.wirelessMaxOutput);
    }

    public void func_145843_s() {
        super.func_145843_s();
        WirelessHandler.INSTANCE.unRegister(this);
        this.registered = false;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.registered) {
            WirelessHandler.INSTANCE.register(this);
            this.registered = false;
        }
        if (this.lastPowered == -1 || this.lastPowered == 0 && this.storage.getEnergyStored() > 0 || this.lastPowered > 0 && this.storage.getEnergyStored() == 0) {
            PacketHandler.INSTANCE.sendToAllAround(new MessageUpdatePower(this), this);
            this.lastPowered = this.storage.getEnergyStored();
        }
    }

    public boolean chargeItems(NonNullList<ItemStack> items) {
        boolean charged = false;
        int availableEnergy = Math.min(this.storage.getMaxOutput(), this.storage.getEnergyStored());
        for (int i = 0; i < items.size() && availableEnergy > 0; ++i) {
            int transferred;
            IEnergyStorage energyStorage;
            ItemStack stack = (ItemStack)items.get(i);
            if (stack.func_190926_b() || !stack.hasCapability(CapabilityEnergy.ENERGY, null) || (energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) == null || stack.func_190916_E() != 1 || (transferred = energyStorage.receiveEnergy(availableEnergy, false)) <= 0) continue;
            this.storage.extractEnergy(transferred, false);
            availableEnergy -= transferred;
            charged = true;
        }
        return charged;
    }

    public boolean canCharge() {
        return this.storage.getEnergyStored() > 0 && !this.isPowered();
    }

    public boolean isPowered() {
        return this.field_145850_b.func_175667_e(this.func_174877_v()) && this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.storage.readFromNBT(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        return this.storage.writeToNBT(super.func_189515_b(compound));
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.storage);
        }
        return (T)super.getCapability(capability, facing);
    }
}

